/*
	CRubikCube.h
	
	Author:	Ivan Pinzon, iPinSoft
	Description:	Single cube: 
					these are used to create the rubik cube

	Creation Date:	Jan. 12/05
	Last Update:	Jan. 12/05
*/

// $Source: /Volumes/Code/CVS/IPA/Graphics/OpenGL/Rubik/CRubikCube.h,v $
// $Revision: 1.5 $
// $Date: 2005/02/18 17:19:20 $
// $Author: ivanp $

#include "CCube.h"

class CRubikCube
{
public:
	static const bool	kSaveRotation = true,
						kAnimate = true;
	
	enum
	{
		kCCW = -90,
		kCW = 90
	};
	
	enum
	{
		kRedTexture,
		kBlueTexture,
		kGreenTexture,
		kWhiteTexture,
		kYellowTexture,
		kOrangeTexture
	};
	
	enum eAnimationSpeed
	{
		kSlow, kNormal, kFast
	};

	
	CRubikCube();
	virtual ~CRubikCube();
	
	virtual void initCube();

	virtual void loadTextures();
	virtual void setUseTexture(bool inUseTexture);
	virtual void setAnimationSpeed(eAnimationSpeed inSpeed);
	
	void drawCube(GLenum inMode);
	void drawFaceHitDetectionCube();
	void drawEnclosingCube();

	void rotateFace(long inFace, long inDirection, bool inSaveRotation, bool inAnimate);
	void rotateFaceModel(long inFace, long inDirection);

	void solveCube();
	void popRotation();

protected:

private:
	struct rotationT
	{
		long face;
		long direction;
	};
	typedef struct rotationT rotationT;

	CCube*				mCubes[3][3][3];
	GLubyte				*mFaceTexturesA[6];
	bool				mUseTexture;
	vector<rotationT>	mRotationV;
	long				mAnimationSpeed;
};
